<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Database\Seeder;

class PoultryDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Poultry Categories
        $liveBirds = Category::create(['name' => 'Live Birds']);
        $eggs = Category::create(['name' => 'Eggs']);
        $processed = Category::create(['name' => 'Processed Products']);
        $feeds = Category::create(['name' => 'Feeds & Supplies']);
        $dayOld = Category::create(['name' => 'Day Old Chicks']);

        // Live Birds Products
        Product::create([
            'name' => 'Broiler Chicken',
            'code' => 'BR001',
            'category_id' => $liveBirds->id,
            'unit_price' => 45.00,
            'description' => 'Fresh broiler chicken, ready for sale'
        ]);

        Product::create([
            'name' => 'Layer Chicken',
            'code' => 'LY001',
            'category_id' => $liveBirds->id,
            'unit_price' => 50.00,
            'description' => 'Mature layer chicken for egg production'
        ]);

        Product::create([
            'name' => 'Cockerel (Local)',
            'code' => 'CK001',
            'category_id' => $liveBirds->id,
            'unit_price' => 55.00,
            'description' => 'Local cockerel'
        ]);

        Product::create([
            'name' => 'Hen (Local)',
            'code' => 'HN001',
            'category_id' => $liveBirds->id,
            'unit_price' => 48.00,
            'description' => 'Local hen'
        ]);

        // Eggs Products
        Product::create([
            'name' => 'Eggs (Tray of 30)',
            'code' => 'EG001',
            'category_id' => $eggs->id,
            'unit_price' => 25.00,
            'description' => 'One tray containing 30 eggs'
        ]);

        Product::create([
            'name' => 'Eggs (Crate)',
            'code' => 'EG002',
            'category_id' => $eggs->id,
            'unit_price' => 120.00,
            'description' => 'Full crate of eggs (approximately 30 trays)'
        ]);

        Product::create([
            'name' => 'Eggs (Per Piece)',
            'code' => 'EG003',
            'category_id' => $eggs->id,
            'unit_price' => 0.90,
            'description' => 'Individual egg'
        ]);

        // Processed Products
        Product::create([
            'name' => 'Dressed Chicken (Whole)',
            'code' => 'DC001',
            'category_id' => $processed->id,
            'unit_price' => 60.00,
            'description' => 'Whole dressed chicken, ready to cook'
        ]);

        Product::create([
            'name' => 'Chicken Parts (Per Kg)',
            'code' => 'CP001',
            'category_id' => $processed->id,
            'unit_price' => 35.00,
            'description' => 'Chicken parts per kilogram'
        ]);

        Product::create([
            'name' => 'Gizzard (Per Kg)',
            'code' => 'GZ001',
            'category_id' => $processed->id,
            'unit_price' => 40.00,
            'description' => 'Chicken gizzard per kilogram'
        ]);

        Product::create([
            'name' => 'Liver (Per Kg)',
            'code' => 'LV001',
            'category_id' => $processed->id,
            'unit_price' => 38.00,
            'description' => 'Chicken liver per kilogram'
        ]);

        // Day Old Chicks
        Product::create([
            'name' => 'Day Old Broiler Chicks',
            'code' => 'DOC001',
            'category_id' => $dayOld->id,
            'unit_price' => 8.50,
            'description' => 'Day old broiler chicks'
        ]);

        Product::create([
            'name' => 'Day Old Layer Chicks',
            'code' => 'DOC002',
            'category_id' => $dayOld->id,
            'unit_price' => 9.00,
            'description' => 'Day old layer chicks'
        ]);

        // Feeds & Supplies
        Product::create([
            'name' => 'Broiler Starter Feed (50kg)',
            'code' => 'FD001',
            'category_id' => $feeds->id,
            'unit_price' => 180.00,
            'description' => 'Broiler starter feed, 50kg bag'
        ]);

        Product::create([
            'name' => 'Layer Feed (50kg)',
            'code' => 'FD002',
            'category_id' => $feeds->id,
            'unit_price' => 175.00,
            'description' => 'Layer feed, 50kg bag'
        ]);

        Product::create([
            'name' => 'Broiler Finisher Feed (50kg)',
            'code' => 'FD003',
            'category_id' => $feeds->id,
            'unit_price' => 170.00,
            'description' => 'Broiler finisher feed, 50kg bag'
        ]);
    }
}
