<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $imageUrl = 'assets/images/revogrit.png';

        Setting::create(['key' => 'app_name', 'value' => 'RIMS']);
        Setting::create(['key' => 'app_logo', 'value' => $imageUrl]);
        Setting::create(['key' => 'company_name', 'value' => 'ZIBOK POULTRY FARM LIMITED']);
        Setting::create(['key' => 'company_logo', 'value' => $imageUrl]);
        Setting::create(['key' => 'date_format', 'value' => 'd/m/Y']); // Ghana format: DD/MM/YYYY
        Setting::create(['key' => 'time_format', 'value' => '0']);
        Setting::create(['key' => 'time_zone', 'value' => 'Africa/Accra']); // Ghana timezone
        // Note: You'll need to set current_currency to the ID of GHS after seeding currencies
        Setting::create(['key' => 'current_currency', 'value' => '3']); // Set after GHS is added
        Setting::create(['key' => 'decimal_separator', 'value' => '.']);
        Setting::create(['key' => 'thousand_separator', 'value' => ',']);

}
}
