<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <link rel="icon" href="{{ asset('web/media/logos/favicon.ico') }}" type="image/png">
    <title>{{ __('messages.invoice.invoice_pdf') }}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/css/invoice-pdf.css') }}" rel="stylesheet" type="text/css" />
    <style>
        * {
            font-family: DejaVu Sans, Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
        }

        @if (getInvoiceCurrencyIcon($invoice->currency_id) == '€')
            .euroCurrency {
                font-family: Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
            }
        @endif

        body {
            padding: 20px;
            background: white;
            margin: 0;
        }

        .invoice-container {
            max-width: 100%;
            margin: 0 auto;
        }

        .invoice-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
        }

        .company-logo-section {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .company-logo-section img {
            width: 100px;
            height: auto;
        }

        .company-info {
            margin-left: 15px;
        }

        .company-info .company-name {
            font-weight: bold;
            color: #2d5016;
            font-size: 14px;
            margin-bottom: 5px;
        }

        .company-info .company-details {
            font-size: 12px;
            color: #333;
            line-height: 1.6;
        }

        .invoice-title-section {
            text-align: right;
        }

        .invoice-title-section h1 {
            font-size: 24px;
            font-weight: bold;
            color: #2d5016;
            margin: 0 0 10px 0;
            text-transform: uppercase;
        }

        .invoice-info {
            font-size: 12px;
            margin-top: 10px;
        }

        .invoice-info div {
            margin-bottom: 5px;
        }

        .invoice-info label {
            font-weight: bold;
            color: #333;
        }

        .billing-section {
            display: flex;
            gap: 15px;
            margin-bottom: 20px;
        }

        .bill-to-box, .ship-to-box {
            flex: 1;
            border: 1px solid #000;
            background-color: #e8f5e9;
            padding: 10px;
        }

        .bill-to-box h3, .ship-to-box h3 {
            font-size: 14px;
            font-weight: bold;
            color: #000;
            margin: 0 0 10px 0;
            text-transform: uppercase;
        }

        .bill-to-box .address-line, .ship-to-box .address-line {
            border-bottom: 1px solid #ccc;
            min-height: 20px;
            margin-bottom: 5px;
            padding-bottom: 3px;
        }

        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .info-table th {
            background-color: #e8f5e9;
            border: 1px solid #000;
            padding: 8px;
            text-align: center;
            font-weight: bold;
            font-size: 12px;
        }

        .info-table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: center;
            font-size: 12px;
        }

        .product-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .product-table thead th {
            background-color: #e8f5e9;
            border: 1px solid #000;
            padding: 10px 5px;
            text-align: center;
            font-weight: bold;
            font-size: 12px;
            text-transform: uppercase;
        }

        .product-table tbody td {
            border: 1px solid #000;
            padding: 8px 5px;
            font-size: 12px;
        }

        .product-table tbody tr:nth-child(even) {
            background-color: #f1f8f4;
        }

        .product-table tbody tr:nth-child(odd) {
            background-color: #fff;
        }

        .product-id {
            text-align: left;
        }

        .product-description {
            text-align: left;
        }

        .product-quantity, .product-price, .product-discount, .product-total {
            text-align: right;
        }

        .summary-section {
            display: flex;
            justify-content: flex-end;
            margin-bottom: 30px;
        }

        .summary-table {
            width: 300px;
            border-collapse: collapse;
        }

        .summary-table td {
            border: 1px solid #000;
            padding: 8px 10px;
            font-size: 12px;
            background-color: #fff;
        }

        .summary-table td:first-child {
            text-align: left;
            font-weight: bold;
        }

        .summary-table td:last-child {
            text-align: right;
        }

        .summary-table .total-row td {
            font-weight: bold;
        }

        .summary-table .total-due-row td {
            font-weight: bold;
        }

        .footer-section {
            margin-top: 40px;
            text-align: center;
        }

        .footer-thank-you {
            background-color: #e8f5e9;
            padding: 15px;
            font-size: 18px;
            font-weight: bold;
            color: #2d5016;
            font-style: italic;
            text-transform: uppercase;
        }

        .text-color {
            color: #333;
        }
    </style>
</head>

<body>
    @php $styleCss = 'style'; @endphp
    <div class="invoice-container">
        <!-- Header Section -->
        <div class="invoice-header">
            <div class="company-logo-section">
                <img src="{{ getLogoUrl() }}" alt="Company Logo">
                <div class="company-info">
                    <div class="company-name">{{ $setting['company_name'] ?? 'Farm, ranch, Agriculture' }}</div>
                    <div class="company-details">
                        {{ $setting['company_address'] ?? 'Street Address' }}<br>
                        @if (isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1)
                            {{ $setting['city'] ?? 'City' }}, {{ $setting['state'] ?? 'ST' }} {{ $setting['zipcode'] ?? 'ZIP Code' }}<br>
                        @else
                            City, ST ZIP Code<br>
                        @endif
                        {{ $setting['company_phone'] ?? 'Phone Number' }}, {{ $setting['company_email'] ?? 'Web Address, etc.' }}
                    </div>
                </div>
            </div>
            <div class="invoice-title-section">
                <h1>SALES INVOICE</h1>
                <div class="invoice-info">
                    <div>
                        <label>DATE:</label> {{ \Carbon\Carbon::parse($invoice->invoice_date)->translatedFormat(currentDateFormat()) }}
                    </div>
                    <div>
                        <label>INVOICE #:</label> #{{ $invoice->invoice_id }}
                    </div>
                </div>
            </div>
        </div>

        <!-- Bill To & Ship To Section -->
        <div class="billing-section">
            <div class="bill-to-box">
                <h3>BILL TO:</h3>
                <div class="address-line">{{ $client->user->full_name }}</div>
                <div class="address-line">{{ $client->user->email }}</div>
                @if (!empty($client->address))
                    <div class="address-line">{{ $client->address }}</div>
                @else
                    <div class="address-line">&nbsp;</div>
                @endif
                @if (!empty($client->vat_no))
                    <div class="address-line">{{ getVatNoLabel() }}: {{ $client->vat_no }}</div>
                @else
                    <div class="address-line">&nbsp;</div>
                @endif
            </div>
            <div class="ship-to-box">
                <h3>SHIP TO:</h3>
                <div class="address-line">{{ $client->user->full_name }}</div>
                <div class="address-line">{{ $client->user->email }}</div>
                @if (!empty($client->address))
                    <div class="address-line">{{ $client->address }}</div>
                @else
                    <div class="address-line">&nbsp;</div>
                @endif
                <div class="address-line">&nbsp;</div>
            </div>
        </div>

        <!-- P.O. #, Sales Rep, Terms, Due Date Table -->
        <table class="info-table">
            <thead>
                <tr>
                    <th>P.O. #</th>
                    <th>Sales Rep. Name</th>
                    <th>Terms</th>
                    <th>Due Date</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $invoice->reference_no ?? '-' }}</td>
                    <td>-</td>
                    <td>{{ $invoice->term ?? '-' }}</td>
                    <td>{{ \Carbon\Carbon::parse($invoice->due_date)->translatedFormat(currentDateFormat()) }}</td>
                </tr>
            </tbody>
        </table>

        <!-- Product Table -->
        <table class="product-table">
            <thead>
                <tr>
                    <th style="width: 12%;">Product ID</th>
                    <th style="width: 30%;">Description</th>
                    <th style="width: 10%;">Quantity</th>
                    <th style="width: 12%;">Unit Price</th>
                    <th style="width: 12%;">Discount</th>
                    <th style="width: 12%;">Line Total</th>
                </tr>
            </thead>
            <tbody>
                @if (isset($invoice) && !empty($invoice))
                    @foreach ($invoice->invoiceItems as $key => $invoiceItems)
                        <tr>
                            <td class="product-id">
                                {{ isset($invoiceItems->product->id) ? 'farm-' . $invoiceItems->product->id : 'farm-' . ($key + 1) }}
                            </td>
                            <td class="product-description">
                                <strong>{{ isset($invoiceItems->product->name) ? $invoiceItems->product->name : $invoiceItems->product_name ?? __('messages.common.n/a') }}</strong>
                                @if (!empty($invoiceItems->product->description) && (isset($setting['show_product_description']) && $setting['show_product_description'] == 1))
                                    <br><span style="font-size: 11px;">{{ $invoiceItems->product->description }}</span>
                                @endif
                            </td>
                            <td class="product-quantity">{{ number_format($invoiceItems->quantity, 2) }}</td>
                            <td class="product-price euroCurrency">
                                {{ isset($invoiceItems->price) ? getInvoiceCurrencyAmount($invoiceItems->price, $invoice->currency_id, true) : __('messages.common.n/a') }}
                            </td>
                            <td class="product-discount">
                                @php
                                    // Calculate discount percentage if applicable
                                    $lineSubtotal = $invoiceItems->quantity * $invoiceItems->price;
                                    $lineTotal = $invoiceItems->total;
                                    $discountAmount = $lineSubtotal - $lineTotal;
                                    $discountPercent = $lineSubtotal > 0 ? ($discountAmount / $lineSubtotal) * 100 : 0;
                                @endphp
                                @if ($discountPercent > 0)
                                    {{ number_format($discountPercent, 2) }}%
                                @else
                                    -
                                @endif
                            </td>
                            <td class="product-total euroCurrency">
                                {{ isset($invoiceItems->total) ? getInvoiceCurrencyAmount($invoiceItems->total, $invoice->currency_id, true) : __('messages.common.n/a') }}
                            </td>
                        </tr>
                    @endforeach
                    @for ($i = count($invoice->invoiceItems); $i < 10; $i++)
                        <tr>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                        </tr>
                    @endfor
                @endif
            </tbody>
        </table>

        <!-- Summary Section -->
        <div class="summary-section">
            <table class="summary-table">
                <tbody>
                    <tr>
                        <td>SUBTOTAL</td>
                        <td class="euroCurrency">{{ getInvoiceCurrencyAmount($invoice->amount, $invoice->currency_id, true) }}</td>
                    </tr>
                    @php
                        $itemTaxesAmount = $invoice->amount + array_sum($totalTax);
                        $invoiceTaxesAmount = ($itemTaxesAmount * $invoice->invoiceTaxes->sum('value')) / 100;
                        $totalTaxes = array_sum($totalTax) + $invoiceTaxesAmount;
                        $taxCount = 1;
                        $displayedTaxes = [];
                    @endphp
                    @if (!empty($invoice->invoiceTaxes) && count($invoice->invoiceTaxes) > 0)
                        @foreach ($invoice->invoiceTaxes as $tax)
                            <tr>
                                <td>Tax {{ $taxCount }} {{ number_format($tax->value, 3) }}%</td>
                                <td class="euroCurrency">
                                    @php
                                        $taxAmount = ($itemTaxesAmount * $tax->value) / 100;
                                    @endphp
                                    {{ getInvoiceCurrencyAmount($taxAmount, $invoice->currency_id, true) }}
                                </td>
                            </tr>
                            @php $taxCount++; @endphp
                        @endforeach
                    @endif
                    @if (count($totalTax) > 0 && !empty($invoice->invoiceItems))
                        @php
                            $itemTaxRates = [];
                            foreach ($invoice->invoiceItems as $item) {
                                foreach ($item->invoiceItemTax as $itemTax) {
                                    if (!isset($itemTaxRates[$itemTax->tax])) {
                                        $itemTaxRates[$itemTax->tax] = 0;
                                    }
                                    $itemTaxRates[$itemTax->tax] += ($item->quantity * $item->price * $itemTax->tax) / 100;
                                }
                            }
                        @endphp
                        @foreach ($itemTaxRates as $rate => $amount)
                            <tr>
                                <td>Tax {{ $taxCount }} {{ number_format($rate, 3) }}%</td>
                                <td class="euroCurrency">{{ getInvoiceCurrencyAmount($amount, $invoice->currency_id, true) }}</td>
                            </tr>
                            @php $taxCount++; @endphp
                        @endforeach
                    @endif
                    <tr>
                        <td>SHIPPING & HANDLING</td>
                        <td>-</td>
                    </tr>
                    <tr class="total-row">
                        <td>TOTAL</td>
                        <td class="euroCurrency">{{ getInvoiceCurrencyAmount($invoice->final_amount, $invoice->currency_id, true) }}</td>
                    </tr>
                    <tr>
                        <td>PAID</td>
                        <td class="euroCurrency">
                            @php
                                $paidAmount = getInvoicePaidAmount($invoice->id);
                            @endphp
                            {{ $paidAmount > 0 ? getInvoiceCurrencyAmount($paidAmount, $invoice->currency_id, true) : '-' }}
                        </td>
                    </tr>
                    <tr class="total-due-row">
                        <td>TOTAL DUE</td>
                        <td class="euroCurrency">{{ getInvoiceCurrencyAmount(getInvoiceDueAmount($invoice->id), $invoice->currency_id, true) }}</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Notes and Terms -->
        @if (!empty($invoice->note))
            <div style="margin-bottom: 15px;">
                <strong>{{ __('messages.client.notes') . ':' }}</strong><br>
                <span class="text-color">{!! nl2br($invoice->note ?? __('messages.common.not_available')) !!}</span>
            </div>
        @endif
        @if (!empty($invoice->term))
            <div style="margin-bottom: 15px;">
                <strong>{{ __('messages.invoice.terms') . ':' }}</strong><br>
                <span class="text-color">{!! nl2br($invoice->term ?? __('messages.common.not_available')) !!}</span>
            </div>
        @endif

        <!-- Footer -->
        <div class="footer-section">
            <div class="footer-thank-you">
                THANK YOU FOR YOUR BUSINESS!
            </div>
        </div>
    </div>
</body>

</html>
