<?php
    $auth = Auth::check();
?>
<div>
    <?php if($auth && $isPublicView): ?>
        <div class="d-flex overflow-auto h-55px">
            <ul class="nav nav-tabs mb-5 pb-1 overflow-auto flex-nowrap text-nowrap">
                <li class="nav-item position-relative me-7 mb-3" role="presentation">
                    <button class="nav-link active p-0" id="overview-tab" data-bs-toggle="tab" data-bs-target="#overview"
                        type="button" role="tab" aria-controls="overview" aria-selected="true">
                        <?php echo e(__('messages.quote.overview')); ?>

                    </button>
                </li>
                <li class="nav-item position-relative me-7 mb-3" role="presentation">
                    <button class="nav-link p-0" id="note_terms-tab" data-bs-toggle="tab" data-bs-target="#note_terms"
                        type="button" role="tab" aria-controls="note_terms" aria-selected="false">
                        <?php echo e(__('messages.quote.note_terms')); ?>

                    </button>
                </li>
            </ul>
        </div>
    <?php endif; ?>
    <div class="tab-content" id="myTabContent">
        <div class="tab-pane fade show active" id="overview" role="tabpanel">
            <div class="card">
                <div class="d-flex flex-column">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-xxl-9">
                                <div class="row">
                                    <div class="col-lg-4 col-md-6">
                                        <div class="d-flex mb-md-10 mb-5">
                                            <div class="image image-circle image-lg-small width-100px">
                                                <img src="<?php echo e(getLogoUrl()); ?>" alt="user" class="object-contain">
                                            </div>
                                            <h3 class="ps-7"><?php echo e(__('messages.quote.quote')); ?>

                                                #<?php echo e($quote->quote_id); ?>

                                            </h3>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-3 col-6">
                                        <div class="d-flex flex-column mb-md-10 mb-5 mt-3 mt-md-0">
                                            <label for="name"
                                                class="pb-2 fs-4 text-gray-600"><?php echo e(__('messages.quote.quote_date') . ':'); ?></label>
                                            <span
                                                class="fs-4 text-gray-800"><?php echo e(\Carbon\Carbon::parse($quote->quote_date)->translatedFormat(currentDateFormat())); ?></span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-3 col-6">
                                        <div class="d-flex flex-column mb-md-10 mb-5 mt-3 mt-md-0">
                                            <label for="name"
                                                class="pb-2 fs-4 text-gray-600"><?php echo e(__('messages.quote.due_date') . ':'); ?></label>
                                            <span
                                                class="fs-4 text-gray-800"><?php echo e(\Carbon\Carbon::parse($quote->due_date)->translatedFormat(currentDateFormat())); ?></span>
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-6 mb-3 mb-sm-0">
                                        <?php if($isPublicView): ?>
                                            <a target="_blank" href="<?php echo e(route('quotes.pdf', ['quote' => $quote->id])); ?>"
                                                class="btn btn-sm btn-success text-white"><?php echo e(__('messages.quote.print_quote')); ?></a>
                                        <?php else: ?>
                                            <a target="_blank"
                                                href="<?php echo e(route('public-view-quote.pdf', ['quote' => $quote->quote_id])); ?>"
                                                class="btn btn-sm btn-success text-white"><?php echo e(__('messages.quote.print_quote')); ?></a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-lg-5 col-md-6">
                                        <div class="d-flex flex-column mb-md-10 mb-5">
                                            <label for="name"
                                                class="pb-2 fs-4 text-gray-600"><?php echo e(__('messages.quote.issue_for') . ':'); ?></label>
                                            <span
                                                class="fs-4 text-gray-800 mb-3"><?php echo e($quote->client->user->full_name); ?></span>
                                            <p class="text-gray-700 fs-4 mb-0">
                                                <?php if(isset($quote->client->address) && !empty($quote->client->address)): ?>
                                                    <?php echo e(ucfirst($quote->client->address)); ?>

                                                <?php else: ?>
                                                    <?php echo e('N/A'); ?>

                                                <?php endif; ?>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-md-6">
                                        <div class="d-flex flex-column mb-md-10 mb-5">
                                            <label for="name"
                                                class="pb-2 fs-4 text-gray-600"><?php echo e(__('messages.quote.issue_by') . ':'); ?></label>
                                            <span class="fs-4 text-gray-800 mb-3"><?php echo e(getAppName()); ?></span>
                                            <p class="text-gray-700 fs-4 mb-0">
                                                <?php echo getSettingValue('company_address'); ?></p>
                                        </div>
                                    </div>
                                    <div class="col-12 table-responsive">
                                        <table class="table table-striped box-shadow-none mt-4">
                                            <thead>
                                                <tr>
                                                    <th scope="col"><?php echo e(__('messages.product.product')); ?></th>
                                                    <th scope="col"><?php echo e(__('messages.quote.qty')); ?></th>
                                                    <th scope="col" class="text-end">
                                                        <?php echo e(__('messages.quote.price')); ?></th>
                                                    <th scope="col" class="text-end">
                                                        <?php echo e(__('messages.quote.amount')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $quote->quoteItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $quoteItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="py-4">
                                                            <?php echo e(isset($quoteItem->product->name) ? $quoteItem->product->name : $quoteItem->product_name ?? 'N/A'); ?>

                                                        </td>
                                                        <td class="py-4"><?php echo e($quoteItem->quantity); ?></td>
                                                        <td class="py-4 text-end min-width-130px">
                                                            <?php echo e(isset($quoteItem->price) ? getCurrencyAmount($quoteItem->price, true) : 'N/A'); ?>

                                                        </td>
                                                        <td class="py-4 text-end min-width-130px">
                                                            <?php echo e(isset($quoteItem->total) ? getCurrencyAmount($quoteItem->total, true) : 'N/A'); ?>

                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="col-lg-5 ms-lg-auto mt-4">
                                        <div class="border-top">
                                            <table class="table table-borderless box-shadow-none mb-0 mt-5">
                                                <tbody>
                                                    <tr>
                                                        <td class="ps-0"><?php echo e(__('messages.quote.sub_total') . ':'); ?>

                                                        </td>
                                                        <td class="text-gray-900 text-end pe-0">
                                                            <?php echo e(isset($quote->amount) ? getCurrencyAmount($quote->amount, true) : 'N/A'); ?>

                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="ps-0"><?php echo e(__('messages.quote.discount') . ':'); ?>

                                                        </td>
                                                        <td class="text-gray-900 text-end pe-0">
                                                            <?php if($quote->discount == 0 || !isset($quote)): ?>
                                                                <span>N/A</span>
                                                            <?php else: ?>
                                                                <?php if($quote->discount_type == \App\Models\Quote::FIXED): ?>
                                                                    <?php echo e(getCurrencyAmount($quote->discount, true)); ?>

                                                                <?php else: ?>
                                                                    <?php echo e(getCurrencyAmount(($quote->amount * $quote->discount) / 100, true)); ?>

                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="ps-0"><?php echo e(__('messages.quote.total') . ':'); ?></td>
                                                        <td class="text-gray-900 text-end pe-0">
                                                            <?php echo e(getCurrencyAmount($quote->final_amount, true)); ?>

                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xxl-3 mb-5 mb-lg-0">
                                <div
                                    class="bg-gray-100 rounded-15 p-md-7 p-5 h-100 mt-xxl-0 mt-5 col-xxl-9 ms-xxl-auto w-100">
                                    <div class="mb-8">
                                        <?php if($quote->status == \App\Models\Quote::DRAFT): ?>
                                            <span class="badge bg-light-warning me-5"><?php echo e(__('messages.draft')); ?></span>
                                        <?php elseif($quote->status == \App\Models\Quote::CONVERTED): ?>
                                            <span
                                                class="badge bg-light-success me-5"><?php echo e(__('messages.converted')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <h3 class="mb-5"><?php echo e(__('messages.quote.client_overview')); ?></h3>
                                    <div class="row">
                                        <div
                                            class="col-xxl-12 col-lg-4 col-sm-6 d-flex flex-column mb-xxl-7 mb-lg-0 mb-4">
                                            <label for="name"
                                                class="pb-2 fs-4 text-gray-600"><?php echo e(__('messages.quote.client_name')); ?></label>
                                            <?php if($auth): ?>
                                                <a href="<?php echo e(route('clients.show', ['client' => $quote->client->id])); ?>"
                                                    class="link-primary text-decoration-none"><?php echo e($quote->client->user->full_name); ?></a>
                                            <?php else: ?>
                                                <a
                                                    class="link-primary fs-4 text-decoration-none"><?php echo e($quote->client->user->full_name); ?></a>
                                            <?php endif; ?>
                                        </div>
                                        <div
                                            class="col-xxl-12 col-lg-4 col-sm-6 d-flex flex-column mb-xxl-7 mb-lg-0 mb-4">
                                            <label for="name"
                                                class="pb-2 fs-4 text-gray-600"><?php echo e(__('messages.quote.client_email')); ?></label>
                                            <span class="fs-4 text-gray-900"><?php echo e($quote->client->user->email); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="tab-pane fade show" id="note_terms" role="tabpanel">
            <div class="card">
                <div class="card-body pt-5">
                    <div class="row">
                        <div class="col-lg-12 mb-5">
                            <div class="fw-bold text-gray-600 fs-7"><?php echo e(__('messages.quote.note') . ':'); ?></div>
                            <div class="fs-6"><?php echo $quote->note ?? __('messages.quote.note_not_found'); ?></div>
                        </div>
                        <div class="col-lg-12 mb-5">
                            <div class="fw-bold text-gray-600 fs-7"><?php echo e(__('messages.quote.terms') . ':'); ?></div>
                            <div class="fs-6"><?php echo $quote->term ?? __('messages.quote.terms_not_found'); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /Users/fowusu/Herd/ims/resources/views/quotes/show_fields.blade.php ENDPATH**/ ?>