<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.invoice.edit_invoice')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex flex-column">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-end mb-5">
                    <h1><?php echo $__env->yieldContent('title'); ?></h1>
                    <a class="btn btn-outline-primary float-end"
                       href="<?php echo e(url()->previous()); ?>"><?php echo e(__('messages.common.back')); ?></a>
                </div>
                <div class="col-12">
                    <?php echo $__env->make('layouts.errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="card">
                    <div class="card-body">
                        <?php echo e(Form::model($invoice, ['route' => ['invoices.update', $invoice->id], 'id' => 'invoiceEditForm'])); ?>

                        <?php echo $__env->make('invoices.edit_fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo e(Form::close()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('invoices.templates.templates', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo e(Form::hidden('invoice_update_url',route('invoices.update', ['invoice' => $invoice->id]),['id' => 'invoiceUpdateUrl'])); ?>

    <?php echo e(Form::hidden('invoice_url',route('invoices.index'),['id' => 'invoiceUrl'])); ?>

    <?php echo e(Form::hidden('invoice_id',$invoice->id,['id' => 'invoiceId'])); ?>

    <?php echo e(Form::hidden('clients',json_encode($clients, true),['id' => 'clients'])); ?>

    <?php echo e(Form::hidden('products',json_encode($associateProducts, true),['id' => 'products'])); ?>

    <?php echo e(Form::hidden('taxes',json_encode($associateTaxes, true),['id' => 'taxes'])); ?>

    <?php echo e(Form::hidden('unique_id',$invoice->invoiceItems->count() + 1 ,['id' => 'uniqueId'])); ?>

    <?php echo e(Form::hidden('invoice_note',isset($invoice->note) ? true : false ,['id' => 'invoiceNote'])); ?>

    <?php echo e(Form::hidden('invoice_term',isset($invoice->term) ? true : false ,['id' => 'invoiceTerm'])); ?>

    <?php echo e(Form::hidden('invoice_recurring',isset($invoice->recurring) ? true : false ,['id' => 'invoiceRecurring'])); ?>

    <?php echo e(Form::hidden('thousand_separator',getSettingValue('thousand_separator') ,['id' => 'thousandSeparator'])); ?>

    <?php echo e(Form::hidden('decimal_separator',getSettingValue('decimal_separator') ,['id' => 'decimalSeparator'])); ?>

    <?php echo e(Form::hidden('default_tax',json_encode($defaultTax, true) ,['id' => 'defaultTax'])); ?>

    <?php echo e(Form::hidden('edit_due_date',$invoice->due_date ,['id' => 'editDueDate'])); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/fowusu/Herd/ims/resources/views/invoices/edit.blade.php ENDPATH**/ ?>