<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <link rel="icon" href="<?php echo e(asset('web/media/logos/favicon.ico')); ?>" type="image/png">
    <title><?php echo e(__('messages.invoice.invoice_pdf')); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/css/invoice-pdf.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        * {
            font-family: DejaVu Sans, Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
        }

        <?php if(getInvoiceCurrencyIcon($invoice->currency_id) == '€'): ?>
            .euroCurrency {
                font-family: Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
            }
        <?php endif; ?>
    </style>
</head>

<body>
    <?php $styleCss = 'style'; ?>
    <div class="container invoice">
        <div class="invoice-header">
            <table width="100%">
                <tr>
                    <td style="vertical-align:top !important;">
                        <div class="companylogo"><img width="100px" src="<?php echo e(getLogoUrl()); ?>" alt=""
                                class="object-contain"></div>
                    </td>
                    <td>
                        <div class="invoice-header-inner">
                            <h3 <?php echo e($styleCss); ?>="color: <?php echo e($invoice_template_color); ?>">
                                <b><?php echo e(__('messages.common.invoice')); ?></b>
                            </h3>
                            <span class="text-color">#<?php echo e($invoice->invoice_id); ?></span>
                        </div>
                    </td>
                </tr>
            </table>
        </div>
        <div class="details-section">
            <table class="mt-10 w-100">
                <thead>
                </thead>
                <tbody>
                    <tr>
                        <td class="invoice-date" style="vertical-align:top !important; width:30.33% !important;">
                            <div>
                                <strong class="font-size-15"><?php echo e(__('messages.invoice.invoice_date') . ':'); ?></strong>
                                <p class="text-color">
                                    <?php echo e(\Carbon\Carbon::parse($invoice->invoice_date)->translatedFormat(currentDateFormat())); ?>

                                </p>
                            </div>
                            <div>
                                <strong class="font-size-15"><?php echo e(__('messages.invoice.due_date') . ':'); ?></strong>
                                <p class="text-color">
                                    <?php echo e(\Carbon\Carbon::parse($invoice->due_date)->translatedFormat(currentDateFormat())); ?>

                                </p>
                            </div>
                        </td>
                        <td class="billedto"
                            style="vertical-align:top !important; width:31.33% !important; overflow:hidden; word-wrap: break-word; word-break: break-all;">
                            <b><?php echo e(__('messages.common.to') . ':'); ?></b><br>
                            <span><b><?php echo e(__('messages.common.name') . ':'); ?></b></span> <span
                                class="text-color"><?php echo e($client->user->full_name); ?></span><br>
                            <span><b><?php echo e(__('messages.common.email') . ':'); ?></b></span>
                            <span class="text-color"><?php echo e($client->user->email); ?></span><br>
                            <?php if(!empty($client->address)): ?>
                                <span><b><?php echo e(__('messages.common.address') . ':'); ?></b></span>
                                <span class="text-color"><?php echo e($client->address); ?></span><br>
                            <?php endif; ?>
                            <?php if(!empty($client->vat_no)): ?>
                                <span><b><?php echo e(getVatNoLabel() . ':'); ?></b></span>
                                <span class="text-color"><?php echo e($client->vat_no); ?></span><br>
                            <?php endif; ?>
                        </td>
                        <td class="from" style="vertical-align:top !important; width:31.33% !important;">
                            <b><?php echo e(__('messages.common.from') . ':'); ?></b><br>
                            <span><b><?php echo e(__('messages.common.name') . ':'); ?></b></span> <span
                                class="text-color"><?php echo e($setting['company_name']); ?></span><br>
                            <b><?php echo e(__('messages.common.address') . ':'); ?>&nbsp;</b><span
                                class="text-break text-color"><?php echo $setting['company_address']; ?></span><br>
                            <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                <div class="text-color">
                                    <?php echo e($setting['zipcode'] . ', ' . $setting['city'] . ', ' . $setting['state'] . ', ' . $setting['country']); ?>

                                </div>
                            <?php endif; ?>
                            <b><?php echo e(__('messages.user.phone') . ':'); ?>&nbsp;</b><span
                                class="text-color"><?php echo e($setting['company_phone']); ?></span><br>
                            <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                <b><?php echo e(__('messages.invoice.fax_no') . ':'); ?>&nbsp;</b><span
                                    class="text-color"><?php echo e($setting['fax_no']); ?></span><br>
                            <?php endif; ?>
                            <?php if(!empty($setting['gst_no'])): ?>
                                <b><?php echo e(getVatNoLabel() . ':'); ?>&nbsp;</b><span
                                    class="text-color text-nowrap"><?php echo e($setting['gst_no']); ?></span><br>
                            <?php endif; ?>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="content">
            <table class="table product-table w-100"
                <?php echo e($styleCss); ?>="border-top: 1px solid <?php echo e($invoice_template_color); ?>

                ;border-bottom: 1px solid <?php echo e($invoice_template_color); ?>">
                <thead class="bg-light"
                    <?php echo e($styleCss); ?>="border-top: 1px solid <?php echo e($invoice_template_color); ?>

                ;border-bottom: 1px solid <?php echo e($invoice_template_color); ?>">
                    <tr>
                        <th style="width:5%;">#</th>
                        <th class="text-uppercase"><?php echo e(__('messages.product.product')); ?></th>
                        <th class="text-center text-uppercase text-nowrap" style="width:14%;">
                            <?php echo e(__('messages.invoice.qty')); ?></th>
                        <th class="text-center text-uppercase text-nowrap" style="width:14%;">
                            <?php echo e(__('messages.product.unit_price')); ?></th>
                        <th class="text-center text-uppercase text-nowrap" style="width:12%;">
                            <?php echo e(__('messages.invoice.tax') . '(in %)'); ?></th>
                        <th class="text-end text-uppercase text-nowrap" style="width:12%;">
                            <?php echo e(__('messages.invoice.amount')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($invoice) && !empty($invoice)): ?>
                        <?php $__currentLoopData = $invoice->invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $invoiceItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td style="width:5%;"><?php echo e($key + 1); ?></td>
                                <td>
                                    <p style="margin:0;">
                                        <b><?php echo e(isset($invoiceItems->product->name) ? $invoiceItems->product->name : $invoiceItems->product_name ?? __('messages.common.n/a')); ?></b>
                                    </p>
                                    <p style="margin:0;" class="text-color">
                                        <?php if(
                                            !empty($invoiceItems->product->description) &&
                                                (isset($setting['show_product_description']) && $setting['show_product_description'] == 1)): ?>
                                        <?php endif; ?>
                                        <?php if(
                                            !empty($invoiceItems->product->description) &&
                                                (isset($setting['show_product_description']) && $setting['show_product_description'] == 1)): ?>
                                            <span
                                                style="font-size: 12px; word-break: break-all"><?php echo e($invoiceItems->product->description); ?></span>
                                        <?php endif; ?>
                                    </p>
                                </td>
                                <td class="text-center text-color text-nowrap" style="width:14%;">
                                    <?php echo e(number_format($invoiceItems->quantity, 2)); ?>

                                </td>
                                <td class="text-center text-color text-nowrap euroCurrency" style="width:14%;">
                                    <?php echo e(isset($invoiceItems->price) ? getInvoiceCurrencyAmount($invoiceItems->price, $invoice->currency_id, true) : __('messages.common.n/a')); ?>

                                </td>
                                <td class="text-center text-color text-nowrap" style="width:12%;">
                                    <?php $__currentLoopData = $invoiceItems->invoiceItemTax; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keys => $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($tax->tax ?? '--'); ?>

                                        <?php if(!$loop->last): ?>
                                            ,
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td class="text-end text-color euroCurrency text-nowrap" style="width:12%;">
                                    <?php echo e(isset($invoiceItems->total) ? getInvoiceCurrencyAmount($invoiceItems->total, $invoice->currency_id, true) : __('messages.common.n/a')); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <table class="w-100 mt-4">
            <tr>
                <td class="w-65" style="vertical-align:bottom !important;">
                    <?php if(!empty($invoice->paymentQrCode)): ?>
                        <div style="">
                            <strong
                                style="font-size: ; margin-right: 142px"><b><?php echo e(__('messages.payment_qr_codes.payment_qr_code')); ?></b></strong><br>
                            <img class="mt-2 ml-3" src="<?php echo e($invoice->paymentQrCode->qr_image); ?>" height="110"
                                width="110" alt="qr-code-image">
                        </div>
                    <?php endif; ?>
                </td>
                <td class="text-end" style="width:35%;">
                    <table class="total-table table w-100">
                        <tbody>
                            <tr class="border-bottom-gray">
                                <td class="left">
                                    <strong><?php echo e(__('messages.invoice.sub_total') . ':'); ?></strong>
                                </td>
                                <td class="text-end text-color euroCurrency">
                                    <?php echo e(getInvoiceCurrencyAmount($invoice->amount, $invoice->currency_id, true)); ?></td>
                            </tr>
                            <tr class="border-bottom-gray">
                                <td class="left">
                                    <strong><?php echo e(__('messages.invoice.discount') . ':'); ?></strong>
                                </td>
                                <td class="text-end text-color">
                                    <?php if($invoice->discount == 0): ?>
                                        <span><?php echo e(__('messages.common.n/a')); ?></span>
                                    <?php else: ?>
                                        <?php if(isset($invoice) && $invoice->discount_type == \App\Models\Invoice::FIXED): ?>
                                            <b
                                                class="euroCurrency"><?php echo e(isset($invoice->discount) ? getInvoiceCurrencyAmount($invoice->discount, $invoice->currency_id, true) : __('messages.common.n/a')); ?></b>
                                        <?php else: ?>
                                            <?php echo e($invoice->discount); ?><span
                                                <?php echo e($styleCss); ?>="font-family: DejaVu Sans">&#37;</span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr class="border-bottom-gray">
                                <?php
                                    $itemTaxesAmount = $invoice->amount + array_sum($totalTax);

                                    $invoiceTaxesAmount =
                                        ($itemTaxesAmount * $invoice->invoiceTaxes->sum('value')) / 100;
                                    $totalTaxes = array_sum($totalTax) + $invoiceTaxesAmount;
                                ?>
                                <td class="left">
                                    <strong><?php echo e(__('messages.invoice.tax') . ':'); ?></strong>
                                </td>

                                <td class="text-end text-color text-nowrap">
                                    <?php echo numberFormat($totalTaxes) != 0
                                        ? '<b class="euroCurrency">' . getInvoiceCurrencyAmount($totalTaxes, $invoice->currency_id, true) . '</b>'
                                        : __('messages.common.n/a'); ?>

                                </td>
                            </tr>

                            <tr class="border-bottom-gray">
                                <td class="font-weight-bold"><?php echo e(__('messages.invoice.total') . ':'); ?></td>
                                <td class="text-nowrap text-end text-color">
                                    <?php echo e(getInvoiceCurrencyAmount($invoice->final_amount, $invoice->currency_id, true)); ?>

                                </td>
                            </tr>

                            <tr
                                <?php echo e($styleCss); ?>="border-top: 1px solid <?php echo e($invoice_template_color); ?>

                ;border-bottom: 1px solid <?php echo e($invoice_template_color); ?>">
                                <td class="font-weight-bold"><?php echo e(__('messages.admin_dashboard.total_due') . ':'); ?></td>
                                <td class="text-nowrap text-end text-color">
                                    <?php echo e(getInvoiceCurrencyAmount(getInvoiceDueAmount($invoice->id), $invoice->currency_id, true)); ?>

                                </td>
                            </tr>
                            <tr
                                <?php echo e($styleCss); ?>="border-top: 1px solid <?php echo e($invoice_template_color); ?>

                ;border-bottom: 1px solid <?php echo e($invoice_template_color); ?>">
                                <td class="font-weight-bold pr-3">
                                    <?php echo e(__('messages.admin_dashboard.total_paid') . ':'); ?>

                                </td>
                                <td class="text-nowrap text-end text-color">
                                    <?php echo e(getInvoiceCurrencyAmount(getInvoicePaidAmount($invoice->id), $invoice->currency_id, true)); ?>

                                </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </table>
        <div class="notes-terms">
            <?php if(!empty($invoice->note)): ?>
                <p><b><?php echo e(__('messages.client.notes') . ':'); ?></b><br><span class="text-color">
                        <?php echo nl2br($invoice->note ?? __('messages.common.not_available')); ?></span></p>
            <?php endif; ?>
            <?php if(!empty($invoice->term)): ?>
                <p><b><?php echo e(__('messages.invoice.terms') . ':'); ?></b><br>
                    <span class="text-color">
                        <?php echo nl2br($invoice->term ?? __('messages.common.not_available')); ?></span>
                </p>
            <?php endif; ?>
        </div>
        <div class="regards">
            <p><b><?php echo e(__('messages.setting.regards') . ':'); ?></b><br>
                <b
                    <?php echo e($styleCss); ?>="color: <?php echo e($invoice_template_color); ?>"><?php echo e(html_entity_decode($setting['app_name'])); ?></b>
            </p>
        </div>
    </div>
</body>

</html>
<?php /**PATH /Users/fowusu/Herd/ims/resources/views/invoices/invoice_template_pdf/newYorkTemplate.blade.php ENDPATH**/ ?>