<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <link rel="icon" href="<?php echo e(asset('web/media/logos/favicon.ico')); ?>" type="image/png">
    <title><?php echo e(__('messages.invoice.invoice_pdf')); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/css/invoice-pdf.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        * {
            font-family: DejaVu Sans, Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
        }

        <?php if(getInvoiceCurrencyIcon($invoice->currency_id) == '€'): ?>
            .euroCurrency {
                font-family: Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
            }
        <?php endif; ?>
    </style>
</head>

<body style="padding: 0rem 0rem !important;">
    <?php $styleCss = 'style'; ?>
    <div class="mb-8 w-100 position-relative" style="background-color:#F9F9F9; padding: 3rem 2rem ;">
        <table class="w-100">
            <tr>
                <td style="vertical-align:top; width: 45% !important;">
                    <div>
                        <img width="100px" src="<?php echo e(getLogoUrl()); ?>" alt="">
                    </div>
                    <?php if(!empty($invoice->paymentQrCode)): ?>
                        <div style="margin-top:67%;">
                            <img src="<?php echo e($invoice->paymentQrCode->qr_image); ?>" height="100" width="100"
                                alt="qr-code-image">
                        </div>
                    <?php endif; ?>
                </td>
                <td style="vertical-align:top; width: 55% !important; padding: 0rem 2rem 0rem 0rem ;">
                    <table class="w-100">
                        <thead>
                            <tr>
                                <th class="f-b" style="width: 50% !important;">
                                    <h4 <?php echo e($styleCss); ?>="color: <?php echo e($invoice_template_color); ?>">
                                        <strong><?php echo e(__('messages.common.invoice')); ?></strong>
                                    </h4>
                                </th>
                                <th class="f-b" style="width: 50% !important;">
                                    <h4 <?php echo e($styleCss); ?>="color: <?php echo e($invoice_template_color); ?>">
                                        #<?php echo e($invoice->invoice_id); ?></h4>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="width: 50% !important;">
                                    <p class="m-0 fw-bold fs-6"><b><?php echo e(__('messages.invoice.invoice_date')); ?></b></p>
                                    <p><?php echo e(\Carbon\Carbon::parse($invoice->invoice_date)->translatedFormat(currentDateFormat())); ?>

                                    </p>
                                </td>
                                <td style="width: 50% !important;">
                                    <p class="m-0 fw-bold fs-6"><b><?php echo e(__('messages.invoice.due_date')); ?></b></p>
                                    <p><?php echo e(\Carbon\Carbon::parse($invoice->due_date)->translatedFormat(currentDateFormat())); ?>

                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td class="pr-5"
                                    style="vertical-align:top !important; width:50% !important; overflow:hidden; word-wrap: break-word; word-break: break-all;">
                                    <p class="m-0 fw-bold fs-6"><b><?php echo e(__('messages.common.from')); ?></b></p>
                                    <span><?php echo e($setting['company_name']); ?></span><br>
                                    <span>
                                        <?php echo $setting['company_address']; ?><br>
                                        <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                            <div>
                                                <?php echo e($setting['zipcode'] . ', ' . $setting['city'] . ', ' . $setting['state'] . ', ' . $setting['country']); ?>

                                            </div>
                                        <?php endif; ?>
                                    </span><br>
                                    <span><?php echo e($setting['company_phone']); ?></span>
                                    <?php if(!empty($setting['gst_no'])): ?>
                                        <span><?php echo e($setting['gst_no']); ?> </span>
                                    <?php endif; ?>
                                </td>
                                <td
                                    style="vertical-align:top !important; width:50% !important; overflow:hidden; word-wrap: break-word; word-break: break-all;">
                                    <p class="m-0 fw-bold fs-6"><b><?php echo e(__('messages.common.to')); ?></b></p>
                                    <span><?php echo e($client->user->full_name); ?></span><br>
                                    <span><?php echo e($client->user->email); ?></span><br>
                                    <span><?php echo e($client->address); ?></span>
                                    <?php if(!empty($client->vat_no)): ?>
                                        <br><span><?php echo e($client->vat_no); ?></span><br>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <br>
    <div class="table-responsive-sm p-4">
        <table class="w-100">
            <thead <?php echo e($styleCss); ?>="border-bottom: 1px solid <?php echo e($invoice_template_color); ?>">
                <tr>
                    <th class="py-1" <?php echo e($styleCss); ?>="color: <?php echo e($invoice_template_color); ?>; width:5%;">#</th>
                    <th class="py-1 in-w-2 text-uppercase" <?php echo e($styleCss); ?>="color: <?php echo e($invoice_template_color); ?>">
                        <?php echo e(__('messages.product.product')); ?></th>
                    <th class="py-1 text-uppercase"
                        <?php echo e($styleCss); ?>="color: <?php echo e($invoice_template_color); ?>; width:9%;">
                        <?php echo e(__('messages.invoice.qty')); ?></th>
                    <th class="py-1 text-center text-uppercase text-nowrap"
                        <?php echo e($styleCss); ?>="color: <?php echo e($invoice_template_color); ?>; width:15%;">
                        <?php echo e(__('messages.product.unit_price')); ?></th>
                    <th class="py-1 text-center text-uppercase text-nowrap"
                        <?php echo e($styleCss); ?>="color: <?php echo e($invoice_template_color); ?>; width:14%;">
                        <?php echo e(__('messages.invoice.tax') . '(in %)'); ?></th>
                    <th class="py-1 text-end text-uppercase text-nowrap"
                        <?php echo e($styleCss); ?>="color: <?php echo e($invoice_template_color); ?>; width:14%; text-align: end !important;">
                        <?php echo e(__('messages.invoice.amount')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if(isset($invoice) && !empty($invoice)): ?>
                    <?php $__currentLoopData = $invoice->invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $invoiceItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="py-1"><span><?php echo e($key + 1); ?></span></td>
                            <td class="py-1 in-w-2">
                                <p class="fw-bold mb-0">
                                    <?php echo e(isset($invoiceItems->product->name) ? $invoiceItems->product->name : $invoiceItems->product_name ?? __('messages.common.n/a')); ?>

                                </p>
                                <?php if(
                                    !empty($invoiceItems->product->description) &&
                                        (isset($setting['show_product_description']) && $setting['show_product_description'] == 1)): ?>
                                <?php endif; ?>
                                <?php if(
                                    !empty($invoiceItems->product->description) &&
                                        (isset($setting['show_product_description']) && $setting['show_product_description'] == 1)): ?>
                                    <span
                                        style="font-size: 12px; word-break: break-all"><?php echo e($invoiceItems->product->description); ?></span>
                                <?php endif; ?>
                            </td>
                            <td class="py-1"><?php echo e(number_format($invoiceItems->quantity, 2)); ?></td>
                            <td class="py-1 text-center text-nowrap">
                                <?php echo e(isset($invoiceItems->price) ? getInvoiceCurrencyAmount($invoiceItems->price, $invoice->currency_id, true) : __('messages.common.n/a')); ?>

                            </td>
                            <td class="py-1 text-center text-nowrap">
                                <?php $__currentLoopData = $invoiceItems->invoiceItemTax; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keys => $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo e($tax->tax ?? '--'); ?>

                                    <?php if(!$loop->last): ?>
                                        ,
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td class="py-1 text-end text-nowrap">
                                <?php echo e(isset($invoiceItems->total) ? getInvoiceCurrencyAmount($invoiceItems->total, $invoice->currency_id, true) : __('messages.common.n/a')); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <table class="w-100  pl-3 pr-4">
        <tr>
            <td style="width:49%;"></td>
            <td <?php echo e($styleCss); ?>="border-top: 1px solid <?php echo e($invoice_template_color); ?>; width:51%;">
                <table class="w-100">
                    <tbody>
                        <tr>
                            <td class="py-1 text-nowrap">
                                <strong><?php echo e(__('messages.invoice.sub_total') . ':'); ?></strong>
                            </td>
                            <td class="py-1 text-nowrap number-align text-nowrap">
                                <?php echo e(getInvoiceCurrencyAmount($invoice->amount, $invoice->currency_id, true)); ?>

                            </td>
                        </tr>
                        <tr>
                            <td class="py-1 text-nowrap">
                                <strong><?php echo e(__('messages.invoice.discount') . ':'); ?></strong>
                            </td>
                            <td class="text-nowrap number-align py-1 text-nowrap">
                                <?php if($invoice->discount == 0): ?>
                                    <span><?php echo e(__('messages.common.n/a')); ?></span>
                                <?php else: ?>
                                    <?php if(isset($invoice) && $invoice->discount_type == \App\Models\Invoice::FIXED): ?>
                                        <b
                                            class="euroCurrency"><?php echo e(isset($invoice->discount) ? getInvoiceCurrencyAmount($invoice->discount, $invoice->currency_id, true) : __('messages.common.n/a')); ?></b>
                                    <?php else: ?>
                                        <?php echo e($invoice->discount); ?><span
                                            <?php echo e($styleCss); ?>="font-family: DejaVu Sans">&#37;</span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <?php
                                $itemTaxesAmount = $invoice->amount + array_sum($totalTax);
                                $invoiceTaxesAmount = ($itemTaxesAmount * $invoice->invoiceTaxes->sum('value')) / 100;
                                $totalTaxes = array_sum($totalTax) + $invoiceTaxesAmount;
                            ?>
                            <td class="fw-bold py-1 text-nowrap">
                                <strong><?php echo e(__('messages.invoice.tax') . ':'); ?></strong>
                            </td>
                            <td class="text-nowrap number-align py-1">
                                <?php echo numberFormat($totalTaxes) != 0
                                    ? '<b class="euroCurrency">' . getInvoiceCurrencyAmount($totalTaxes, $invoice->currency_id, true) . '</b>'
                                    : __('messages.common.n/a'); ?>

                            </td>
                        </tr>
                        <tr>
                            <td class="py-1 text-nowrap">
                                <strong><?php echo e(__('messages.invoice.total') . ':'); ?></strong>
                            </td>
                            <td class="text-nowrap number-align py-1">
                                <b
                                    class="euroCurrency"><?php echo e(getInvoiceCurrencyAmount($invoice->final_amount, $invoice->currency_id, true)); ?></b>
                            </td>
                        </tr>
                    </tbody>
                    <tfoot <?php echo e($styleCss); ?>="border-top: 1px solid <?php echo e($invoice_template_color); ?>">
                        <tr>
                            <td class="pt-2 text-nowrap">
                                <strong><?php echo e(__('messages.admin_dashboard.total_due') . ':'); ?></strong>
                            </td>
                            <td class="text-nowrap number-align pt-2">
                                <b
                                    class="euroCurrency"><?php echo e(getInvoiceCurrencyAmount(getInvoiceDueAmount($invoice->id), $invoice->currency_id, true)); ?></b>
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </td>
        </tr>
    </table>
    <div class="p-4 mt-5">
        <div class="notes-terms">
            <?php if(!empty($invoice->note)): ?>
                <p><b><?php echo e(__('messages.client.notes') . ':'); ?></b><br><span class="text-color">
                        <?php echo nl2br($invoice->note ?? __('messages.common.not_available')); ?></span></p>
            <?php endif; ?>
            <?php if(!empty($invoice->term)): ?>
                <p><b><?php echo e(__('messages.invoice.terms') . ':'); ?></b><br>
                    <span class="text-color">
                        <?php echo nl2br($invoice->term ?? __('messages.common.not_available')); ?></span>
                </p>
            <?php endif; ?>
        </div>
        <div class="regards">
            <p><b><?php echo e(__('messages.setting.regards') . ':'); ?></b><br>
                <b
                    <?php echo e($styleCss); ?>="color: <?php echo e($invoice_template_color); ?>"><?php echo e(html_entity_decode($setting['app_name'])); ?></b>
            </p>
        </div>
    </div>

</body>

</html>
<?php /**PATH /Users/fowusu/Herd/ims/resources/views/invoices/invoice_template_pdf/torontoTemplate.blade.php ENDPATH**/ ?>