<div class="row">
    <div class="col-lg-3 col-sm-12">
        <?php if($invoice->status == \App\Models\Invoice::DRAFT): ?>
            <?php echo e(Form::label('client_id', __('messages.invoice.client') . ':', ['class' => 'form-label required fs-6 mb-3'])); ?>

            <?php echo e(Form::select('client_id', $clients, $client_id ?? null, ['class' => 'form-select io-select2', 'id' => 'client_id', 'placeholder' => __('messages.invoice.client'), 'required', 'data-control' => 'select2'])); ?>

        <?php else: ?>
            <?php echo e(Form::label('client_id', __('messages.invoice.client') . ':', ['class' => 'form-label mb-3'])); ?>

            <br>
            <span class="text-muted h3"><?php echo e($invoice->client->user->full_name); ?></span>
            <input type="hidden" value="<?php echo e($invoice->client->user_id); ?>" name="client_id">
        <?php endif; ?>
    </div>
    <div class="col-lg-3 col-sm-12 mt-3 mt-lg-1 mb-lg-0 mb-3">
        <h4 class="align-items-center"><?php echo e(__('messages.invoice.invoice')); ?> # <span
                class="text-gray-500"><?php echo e($invoice->invoice_id); ?></span></h4>
        <input type="hidden" id="invoiceId" value="<?php echo e($invoice->invoice_id); ?>" name="invoice_id" />
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="mb-5">
            <?php echo e(Form::label('status', __('messages.common.status') . ':', ['class' => 'form-label required mb-3'])); ?>

            <?php echo e(Form::select('status', getTranslatedData($statusArr), isset($invoice) ? $invoice->status : null, ['class' => 'form-select', 'id' => 'status', 'required', 'data-control' => 'select2'])); ?>

        </div>
    </div>
</div>
<div class="row mb-2">
    <div class="mb-5 col-lg-3 col-sm-12">
        <?php echo e(Form::label('invoice_date', __('messages.invoice.invoice_date') . ':', ['class' => 'form-label required mb-3'])); ?>

        <?php echo e(Form::text('invoice_date', null, ['class' => 'form-select', 'id' => 'editInvoiceDate', 'autocomplete' => 'off', 'required'])); ?>

    </div>
    <div class="mb-5 col-lg-3 col-sm-12">
        <?php echo e(Form::label('due_date', __('messages.invoice.due_date') . ':', ['class' => 'form-label required mb-3'])); ?>

        <?php echo e(Form::text('due_date', null, ['class' => 'form-select', 'id' => 'editDueDate', 'autocomplete' => 'off', 'required'])); ?>

    </div>
    <div class="mb-5 col-lg-3 col-sm-12">
        <?php echo e(Form::label('templateId', __('messages.setting.invoice_template') . ':', ['class' => 'form-label mb-3'])); ?>

        <?php echo e(Form::select('template_id', $template, isset($invoice) ? $invoice->template_id : null, ['class' => 'form-select', 'id' => 'templateId', 'required', 'data-control' => 'select2'])); ?>

    </div>

    <div class="mb-5 col-lg-3 col-sm-12">
        <?php echo e(Form::label('payment_qr_code_id', __('messages.payment_qr_codes.payment_qr_code') . ':', ['class' => 'form-label mb-3'])); ?>

        <?php echo e(Form::select('payment_qr_code_id', $paymentQrCodes, isset($invoice) ? $invoice->paymentQrCodes?->id : null, ['class' => 'form-select io-select2 payment-qr-code', 'data-control' => 'select2', 'placeholder' => __('messages.flash.select_payment_qr_code')])); ?>

        </select>

    </div>
    <div class="mb-5 col-lg-3 col-sm-12">
        <?php echo e(Form::label('currencyType', __('messages.setting.currencies') . ':', ['class' => 'form-label mb-3'])); ?>

        <select id="currencyType" class="form-select invoice-currency-type" name="currency_id">
            <option value=""><?php echo e(__('messages.flash.select_currency')); ?></option>
            <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($currency['id']); ?>"
                    <?php echo e($invoice->currency_id == $currency['id'] ? 'selected' : ''); ?>><?php echo e($currency['icon']); ?>

                    &nbsp;&nbsp;&nbsp; <?php echo e($currency['name']); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="mt-5 col-lg-3 col-sm-12">
        <label class="form-check form-switch form-check-custom mt-5">
            <input class="form-check-input recurring-status" type="checkbox" name="recurring_status"
                id="recurringStatusToggle" <?php echo e($invoice->recurring_status ? 'checked' : ''); ?>>
            <span class="form-check-label text-gray-600"
                for="recurringStatusToggle"><?php echo e(__('messages.invoice.this_is_recurring_invoice')); ?></span>&nbsp;&nbsp;
        </label>
    </div>
    <div class="mb-5 col-lg-3 col-sm-12 recurring-cycle-content">
        <?php echo e(Form::label('recurringCycle', __('messages.invoice.recurring_cycle') . ':', ['class' => 'form-label mb-3'])); ?>

        <?php echo e(Form::number('recurring_cycle', $invoice->recurring_cycle, ['class' => 'form-control', 'id' => 'recurringCycle', 'autocomplete' => 'off', 'placeholder' => __('messages.flash.number_of_days_for_recurring_cycle')])); ?>

    </div>
</div>
<div class="mb-0">
    <div class="col-12 text-end my-5">
        <button type="button" class="btn btn-primary text-start" id="addItem">
            <?php echo e(__('messages.invoice.add')); ?></button>
    </div>
    <div class="table-responsive">
        <table class="table table-striped box-shadow-none mt-4" id="billTbl">
            <thead>
                <tr class="border-bottom fs-7 fw-bolder text-gray-700 text-uppercase">
                    <th scope="col">#</th>
                    <th scope="col" class="required"><?php echo e(__('messages.product.product')); ?></th>
                    <th scope="col" class="required"><?php echo e(__('messages.invoice.qty')); ?></th>
                    <th scope="col" class="required"><?php echo e(__('messages.product.unit_price')); ?></th>
                    <th scope="col"><?php echo e(__('messages.invoice.tax')); ?></th>
                    <th scope="col" class="required"><?php echo e(__('messages.invoice.amount')); ?></th>
                    <th scope="col" class="text-end"><?php echo e(__('messages.common.action')); ?></th>
                </tr>
            </thead>
            <tbody class="invoice-item-container">
                <?php
                    $i = 1;
                ?>
                <?php $__currentLoopData = $invoice->invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoiceItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="tax-tr">
                        <td class="text-center item-number align-center"><?php echo e($i++); ?></td>
                        <td class="table__item-desc w-25">
                            <?php echo e(Form::select('product_id[]', $products, isset($invoiceItem->product_id) ? $invoiceItem->product_id : $invoiceItem->product_name ?? [], ['class' => 'form-select productId product io-select2', 'required', 'placeholder' => __('messages.flash.select_product_or_enter_free_text'), 'data-control' => 'select2'])); ?>

                            <?php echo e(Form::hidden('id[]', $invoiceItem->id)); ?>

                        </td>
                        <td class="table__qty">
                            <?php echo e(Form::number('quantity[]', number_format($invoiceItem->quantity, 2), ['class' => 'form-control qty ', 'id' => 'qty', 'required', 'type' => 'number', 'min' => '0', 'step' => '.01', 'oninput' => "validity.valid||(value=value.replace(/[e\+\-]/gi,''))"])); ?>

                        </td>
                        <td>
                            <?php echo e(Form::number('price[]', $invoiceItem->price, ['class' => 'form-control price-input price ', 'oninput' => "validity.valid||(value=value.replace(/[e\+\-]/gi,''))", 'min' => '0', 'step' => '.01', 'required', 'onKeyPress' => 'if(this.value.length==8) return false;'])); ?>

                        </td>
                        <td>
                            <select name="tax[]" class='form-select  fw-bold tax io-select2' data-control='select2'
                                multiple="multiple">
                                <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(empty($selectedTaxes)): ?>
                                        <option value="<?php echo e($tax->value); ?>" data-id="<?php echo e($tax->id); ?>">
                                            <?php echo e($tax->name); ?>

                                        </option>
                                    <?php elseif(in_array($tax->id, $selectedTaxes[$invoiceItem->id])): ?>
                                        <option value="<?php echo e($tax->value); ?>"
                                            <?php echo e(in_array($tax->id, $selectedTaxes[$invoiceItem->id]) && in_array($tax->id, $selectedTaxes[$invoiceItem->id]) ? 'selected' : ''); ?>

                                            data-id="<?php echo e($tax->id); ?>">
                                            <?php echo e($tax->name); ?>

                                        </option>
                                    <?php else: ?>
                                        <option value="<?php echo e($tax->value); ?>" data-id="<?php echo e($tax->id); ?>">
                                            <?php echo e($tax->name); ?>

                                        </option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td class="text-end item-total pt-8 text-nowrap">
                            <?php echo e(number_format($invoiceItem->total, 2)); ?>

                        </td>
                        <td class="text-end">
                            <button type="button" title="Delete"
                                class="btn btn-icon fs-3 text-danger btn-active-color-danger delete-invoice-item">
                                <i class="fa-solid fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <div class="row">
        <div class="col-lg-7 col-sm-12 mt-2 mt-lg-0 align-right-for-full-screen">
            <div class="mb-2 col-xl-5 col-lg-8 col-sm-12">
                <?php echo e(Form::label('discount', __('messages.invoice.discount') . ':', ['class' => 'form-label mb-1'])); ?>

                <div class="input-group">
                    <?php echo e(Form::number('discount', isset($invoice) ? $invoice->discount : 0, ['id' => 'discount', 'class' => 'form-control ', 'oninput' => "validity.valid||(value=value.replace(/[e\+\-]/gi,''))", 'min' => '0', 'value' => '0', 'step' => '.01', 'pattern' => "^\d*(\.\d{0,2})?$"])); ?>

                    <div class="input-group-append" style="width: 210px !important;">
                        <?php echo e(Form::select('discount_type', getTranslatedData($discount_type), isset($invoice) ? $invoice->discount_type : 0, ['class' => 'form-select', 'id' => 'discountType', 'data-control' => 'select2'])); ?>

                    </div>
                </div>
            </div>
            <div class="mb-2 col-xl-5 col-lg-8 col-sm-12">
                <?php echo e(Form::label('taxes', __('messages.invoice.tax') . ':', ['class' => 'form-label mb-1'])); ?>

                <select name="taxes[]" class='form-select io-select2 fw-bold invoice-taxes' data-control='select2'
                    multiple="multiple">
                    <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($tax->id); ?>" data-tax="<?php echo e($tax->value); ?>"
                            <?php echo e(in_array($tax->id, $selectedInvoiceTaxes) ? 'selected' : ''); ?>><?php echo e($tax->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
        <div class="col-xxl-3 col-lg-5 col-md-6 ms-md-auto mt-4 mb-lg-10 mb-6">
            <div class="border-top">
                <table class="table table-borderless box-shadow-none mb-0 mt-5">
                    <tbody>
                        <tr>
                            <td class="ps-0"><?php echo e(__('messages.invoice.sub_total') . ':'); ?></td>
                            <td class="text-gray-900 text-end pe-0">
                                <?php if(!getSettingValue('currency_after_amount')): ?>
                                    <span
                                        class="invoice-selected-currency"><?php echo e(getInvoiceCurrencyIcon($invoice->currency_id)); ?></span>
                                <?php endif; ?>
                                <span id="total" class="price">
                                    <?php echo e(isset($invoice) ? number_format($invoice->amount, 2) : 0); ?>

                                </span>
                                <?php if(getSettingValue('currency_after_amount')): ?>
                                    <span
                                        class="invoice-selected-currency"><?php echo e(getInvoiceCurrencyIcon($invoice->currency_id)); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td class="ps-0"><?php echo e(__('messages.invoice.discount') . ':'); ?></td>
                            <td class="text-gray-900 text-end pe-0">
                                <?php if(!getSettingValue('currency_after_amount')): ?>
                                    <span
                                        class="invoice-selected-currency"><?php echo e(getInvoiceCurrencyIcon($invoice->currency_id)); ?></span>
                                <?php endif; ?>
                                <span id="discountAmount">
                                    <?php if(isset($invoice) && $invoice->discount_type == \App\Models\Invoice::FIXED): ?>
                                        <?php echo e($invoice->discount ?? 0); ?>

                                    <?php else: ?>
                                        <?php echo e(isset($invoice) ? number_format(($invoice->amount * $invoice->discount) / 100, 2) : 0); ?>

                                    <?php endif; ?>
                                </span>
                                <?php if(getSettingValue('currency_after_amount')): ?>
                                    <span
                                        class="invoice-selected-currency"><?php echo e(getInvoiceCurrencyIcon($invoice->currency_id)); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td class="ps-0"><?php echo e(__('messages.invoice.total_tax') . ':'); ?></td>
                            <td class="text-gray-900 text-end pe-0">
                                <?php if(!getSettingValue('currency_after_amount')): ?>
                                    <span
                                        class="invoice-selected-currency"><?php echo e(getInvoiceCurrencyIcon($invoice->currency_id)); ?></span>
                                <?php endif; ?>
                                <span id="totalTax">
                                    0
                                </span>
                                <?php if(getSettingValue('currency_after_amount')): ?>
                                    <span
                                        class="invoice-selected-currency"><?php echo e(getInvoiceCurrencyIcon($invoice->currency_id)); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td class="ps-0"><?php echo e(__('messages.invoice.total') . ':'); ?></td>
                            <td class="text-gray-900 text-end pe-0">
                                <?php if(!getSettingValue('currency_after_amount')): ?>
                                    <span
                                        class="invoice-selected-currency"><?php echo e(getInvoiceCurrencyIcon($invoice->currency_id)); ?></span>
                                <?php endif; ?>
                                <span id="finalAmount">
                                    <?php echo e(isset($invoice) ? number_format($invoice->amount - ($invoice->amount * $invoice->discount) / 100, 2) : 0); ?>

                                </span>
                                <?php if(getSettingValue('currency_after_amount')): ?>
                                    <span
                                        class="invoice-selected-currency"><?php echo e(getInvoiceCurrencyIcon($invoice->currency_id)); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <br>
    <div class="row justify-content-left">
        <div class="col-lg-12 col-md-12 col-sm-12 end justify-content-left mb-sm-0 mb-5">
            <button type="button" class="btn btn-primary note" id="addNote">
                <i class="fas fa-plus"></i> <?php echo e(__('messages.invoice.add_note_term')); ?>

            </button>
            <button type="button" class="btn btn-danger note" id="removeNote">
                <i class="fas fa-minus"></i> <?php echo e(__('messages.invoice.remove_note_term')); ?>

            </button>
        </div>
        <div class="col-lg-6 mb-0 mb-sm-5 mt-0 mt-sm-5" id="noteAdd">
            <?php echo e(Form::label('note', __('messages.invoice.note') . ':', ['class' => 'form-label fs-6 mb-3'])); ?>

            <?php echo e(Form::textarea('note', isset($invoice) ? $invoice->note : null, ['class' => 'form-control', 'id' => 'note', 'rows' => '5'])); ?>

        </div>
        <div class="col-lg-6 mt-5 mb-5" id="termRemove">
            <?php echo e(Form::label('term', __('messages.invoice.terms') . ':', ['class' => 'form-label fs-6 mb-3'])); ?>

            <?php echo e(Form::textarea('term', isset($invoice) ? $invoice->term : null, ['class' => 'form-control', 'id' => 'term', 'rows' => '5'])); ?>

        </div>
    </div>
</div>
<!-- Total Amount Field -->
<?php echo e(Form::hidden('amount', isset($invoice) ? number_format($invoice->amount - ($invoice->amount * $invoice->discount) / 100, 2) : 0, ['class' => 'form-control', 'id' => 'total_amount'])); ?>


<!-- Final Amount Field -->
<?php echo e(Form::hidden('final_amount', isset($invoice) ? $invoice->final_amount : 0, ['class' => 'form-control', 'id' => 'finalTotalAmt'])); ?>


<!-- Submit Field -->
<div class="float-end">
    <div class="form-group col-sm-12">
        <button type="button" name="save" class="btn btn-primary mx-1 ms-ms-3 mb-3 mb-sm-0" id="editSave"
            data-status="0" value="0"><?php echo e(__('messages.common.save')); ?>

        </button>
        <?php if($invoice->status == \App\Models\Invoice::DRAFT): ?>
            <button type="button" name="save_send" class="btn btn-primary mx-1 ms-ms-3 mb-3 mb-sm-0"
                id="editSaveAndSend" data-status="1" value="1"><?php echo e(__('messages.common.save_send')); ?>

            </button>
        <?php endif; ?>
        <a href="<?php echo e(route('invoices.index')); ?>"
            class="btn btn-secondary btn-active-light-primary"><?php echo e(__('messages.common.cancel')); ?></a>
    </div>
</div>
<?php /**PATH /Users/fowusu/Herd/ims/resources/views/invoices/edit_fields.blade.php ENDPATH**/ ?>