<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <link rel="icon" href="<?php echo e(asset('web/media/logos/favicon.ico')); ?>" type="image/png">
    <title><?php echo e(__('messages.invoice.invoice_pdf')); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/css/invoice-pdf.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        * {
            font-family: DejaVu Sans, Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
        }

        <?php if(getInvoiceCurrencyIcon($invoice->currency_id) == '€'): ?>
            .euroCurrency {
                font-family: Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
            }
        <?php endif; ?>
    </style>
</head>

<body style="padding: rem 2rem;">
    <?php $styleCss = 'style'; ?>
    <div>
        <div class="d" id="boxes">
            <div class="d-inner" style="margin-top:-40px !important;">
                <div class="header-section mb-5" <?php echo e($styleCss); ?>="background-color: <?php echo e($invoice_template_color); ?>;">
                    <table class="w-100 pt-5">
                        <tr>
                            <td class="bg-gray-100">
                                <div class="px-3">
                                    <img width="100px" src="<?php echo e(getLogoUrl()); ?>" alt="">
                                </div>
                            </td>
                            <td class="bg-black invoice-text" style="width:45%;">
                                <div class="text-end">
                                    <h1 class="m-0 p-3" style="color:white;  font-size: 34px">
                                        <b><?php echo e(__('messages.common.invoice')); ?></b>
                                    </h1>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td></td>
                            <td class="text-white text-end px-3 py-2 fs-6"><strong>#<?php echo e($invoice->invoice_id); ?></strong>
                            </td>
                        </tr>
                    </table>
                </div>
                <table class="mb-8 w-100">
                    <tbody>
                        <tr style="vertical-align:top;">
                            <td width="33.33%">
                                <p class="fs-6 mb-2"><strong><?php echo e(__('messages.common.from') . ':'); ?></strong></p>
                                <p class=" m-0 font-color-gray fw-bold fs-6">
                                    <strong><?php echo e(__('messages.common.name') . ':'); ?>&nbsp;</strong>
                                    <?php echo $setting['company_name']; ?>

                                </p>
                                <p class=" m-0 font-color-gray fw-bold fs-6">
                                    <strong><?php echo e(__('messages.common.address') . ':'); ?>&nbsp;</strong>
                                    <?php echo $setting['company_address']; ?>

                                </p>
                                <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                    <p class=" m-0 font-color-gray fs-6">
                                        <?php echo e($setting['zipcode'] . ', ' . $setting['city'] . ', ' . $setting['state'] . ', ' . $setting['country']); ?>

                                    </p>
                                <?php endif; ?>
                                <p class=" m-0 font-color-gray fs-6">
                                    <strong><?php echo e(__('messages.user.phone') . ':'); ?>&nbsp;</strong><span
                                        class="text-color"><?php echo e($setting['company_phone']); ?></span>
                                </p>
                                <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                    <p class=" m-0 font-color-gray fs-6">
                                        <strong><?php echo e(__('messages.invoice.fax_no') . ':'); ?>&nbsp;</strong><span
                                            class="text-color"><?php echo e($setting['fax_no']); ?></span>
                                    <p>
                                <?php endif; ?>
                                <?php if(!empty($setting['gst_no'])): ?>
                                    <p class=" m-0 font-color-gray fw-bold fs-6">
                                        <strong><?php echo e(getVatNoLabel() . ':'); ?>&nbsp;</strong>
                                        <?php echo e($setting['gst_no']); ?>

                                    </p>
                                <?php endif; ?>
                            </td>
                            <td width="33.33%" class="ps-5rem">
                                <p class="fs-6 mb-2"><strong><?php echo e(__('messages.common.to') . ':'); ?></strong></p>
                                <p class="m-0 font-color-gray fs-6"><strong><?php echo e(__('messages.common.name') . ':'); ?>

                                    </strong> <?php echo e($client->user->full_name); ?></p>
                                <p class="m-0 font-color-gray fs-6">
                                    <strong><?php echo e(__('messages.common.email') . ':'); ?></strong>
                                    <?php echo e($client->user->email); ?>

                                </p>
                                <p class=" m-0  font-color-gray fs-6"><strong><?php echo e(__('messages.common.address') . ':'); ?>

                                    </strong><?php echo e($client->address); ?></p>
                                <?php if(!empty($client->vat_no)): ?>
                                    <p class="m-0 font-color-gray fs-6">
                                        <strong><?php echo e(getVatNoLabel() . ':'); ?>

                                        </strong><?php echo e($client->vat_no); ?>

                                    </p>
                                <?php endif; ?>
                            </td>
                            <td width="33.33%" class="text-end">
                                <p class="mb-2 font-color-gray fs-6">
                                    <strong><?php echo e(__('messages.invoice.invoice_date') . ':'); ?></strong>
                                    <?php echo e(\Carbon\Carbon::parse($invoice->invoice_date)->translatedFormat(currentDateFormat())); ?>

                                </p>
                                <p class="  font-color-gray fs-6">
                                    <strong><?php echo e(__('messages.invoice.due_date') . ':'); ?>&nbsp;
                                    </strong><?php echo e(\Carbon\Carbon::parse($invoice->due_date)->translatedFormat(currentDateFormat())); ?>

                                </p>
                                <?php if(!empty($invoice->paymentQrCode)): ?>
                                    <img class="mt-4" src="<?php echo e($invoice->paymentQrCode->qr_image); ?>" height="100"
                                        width="100" alt="qr-code-image">
                                <?php endif; ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table class="border-b-gray w-100 mt-5">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="p-2" style="width:5% !important;">#</th>
                            <th class="p-2 in-w-2 text-uppercase"><?php echo e(__('messages.product.product')); ?></th>
                            <th class="p-2 text-center text-uppercase" style="width:9% !important;">
                                <?php echo e(__('messages.invoice.qty')); ?>

                            </th>
                            <th class="p-2 text-center text-nowrap text-uppercase" style="width:15% !important;">
                                <?php echo e(__('messages.product.unit_price')); ?></th>
                            <th class="p-2 text-center text-nowrap text-uppercase" style="width:13% !important;">
                                <?php echo e(__('messages.invoice.tax') . '(in %)'); ?>

                            </th>
                            <th class="p-2 text-end text-nowrap text-uppercase" style="width:14% !important;">
                                <?php echo e(__('messages.invoice.amount')); ?>

                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($invoice) && !empty($invoice)): ?>
                            <?php $__currentLoopData = $invoice->invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $invoiceItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="p-2" style="width:5%"><span><?php echo e($key + 1); ?></span></td>
                                    <td class="p-2 in-w-2">
                                        <p class="fw-bold mb-0">
                                            <?php echo e(isset($invoiceItems->product->name) ? $invoiceItems->product->name : $invoiceItems->product_name ?? __('messages.common.n/a')); ?>

                                        </p>
                                        <?php if(
                                            !empty($invoiceItems->product->description) &&
                                                (isset($setting['show_product_description']) && $setting['show_product_description'] == 1)): ?>
                                        <?php endif; ?>
                                        <?php if(
                                            !empty($invoiceItems->product->description) &&
                                                (isset($setting['show_product_description']) && $setting['show_product_description'] == 1)): ?>
                                            <span
                                                style="font-size: 12px; word-break: break-all !important"><?php echo e($invoiceItems->product->description); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="p-2 text-center text-nowrap" style="width:9%;">
                                        <?php echo e(number_format($invoiceItems->quantity, 2)); ?></td>
                                    <td class="p-2 text-center text-nowrap" style="width:15%;">
                                        <?php echo e(isset($invoiceItems->price) ? getInvoiceCurrencyAmount($invoiceItems->price, $invoice->currency_id, true) : __('messages.common.n/a')); ?>

                                    </td>
                                    <td class="p-2 text-center text-nowrap" style="width:14%;">
                                        <?php $__currentLoopData = $invoiceItems->invoiceItemTax; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keys => $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($tax->tax ?? '--'); ?>

                                            <?php if(!$loop->last): ?>
                                                ,
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td class="p-2 text-end text-nowrap" style="width:14%;">
                                        <?php echo e(isset($invoiceItems->total) ? getInvoiceCurrencyAmount($invoiceItems->total, $invoice->currency_id, true) : __('messages.common.n/a')); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
                <table class="w-100">
                    <tr>
                        <td class="w-50"></td>
                        <td class="w-50">
                            <table class="w-100">
                                <tbody>
                                    <tr>
                                        <td class="py-1 px-2 text-nowrap">
                                            <strong><?php echo e(__('messages.invoice.sub_total') . ':'); ?></strong>
                                        </td>
                                        <td class="text-end text-nowrap font-color-gray py-1 px-2 fw-bold">
                                            <?php echo e(getInvoiceCurrencyAmount($invoice->amount, $invoice->currency_id, true)); ?>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="py-1 px-2 text-nowrap">
                                            <strong><?php echo e(__('messages.invoice.discount') . ':'); ?></strong>
                                        </td>
                                        <td class="text-end text-nowrap font-color-gray py-1 px-2 fw-bold">
                                            <?php if($invoice->discount == 0): ?>
                                                <span><?php echo e(__('messages.common.n/a')); ?></span>
                                            <?php else: ?>
                                                <?php if(isset($invoice) && $invoice->discount_type == \App\Models\Invoice::FIXED): ?>
                                                    <b
                                                        class="euroCurrency"><?php echo e(isset($invoice->discount) ? getInvoiceCurrencyAmount($invoice->discount, $invoice->currency_id, true) : __('messages.common.n/a')); ?></b>
                                                <?php else: ?>
                                                    <?php echo e($invoice->discount); ?><span
                                                        <?php echo e($styleCss); ?>="font-family: DejaVu Sans">&#37;</span>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <?php
                                            $itemTaxesAmount = $invoice->amount + array_sum($totalTax);
                                            $invoiceTaxesAmount =
                                                ($itemTaxesAmount * $invoice->invoiceTaxes->sum('value')) / 100;
                                            $totalTaxes = array_sum($totalTax) + $invoiceTaxesAmount;
                                        ?>
                                        <td class="py-1 px-2 text-nowrap">
                                            <strong><?php echo e(__('messages.invoice.tax') . ':'); ?></strong>
                                        </td>
                                        <td class="text-end text-nowrap font-color-gray py-1 px-2 fw-bold">
                                            <?php echo numberFormat($totalTaxes) != 0
                                                ? '<b class="euroCurrency">' . getInvoiceCurrencyAmount($totalTaxes, $invoice->currency_id, true) . '</b>'
                                                : __('messages.common.n/a'); ?>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold text-nowrap py-1 px-2">
                                            <strong><?php echo e(__('messages.invoice.total') . ':'); ?></strong>
                                        </td>
                                        <td class="text-end text-nowrap py-1 px-2 fw-bold">
                                            <?php echo e(getInvoiceCurrencyAmount($invoice->final_amount, $invoice->currency_id, true)); ?>

                                        </td>
                                    </tr>
                                </tbody>
                                <tfoot class="text-white"
                                    <?php echo e($styleCss); ?>="background-color: <?php echo e($invoice_template_color); ?>;">
                                    <tr>
                                        <td class="p-2 text-nowrap">
                                            <strong><?php echo e(__('messages.admin_dashboard.total_due') . ':'); ?></strong>
                                        </td>
                                        <td class="text-end p-2 text-nowrap">
                                            <strong><?php echo e(getInvoiceCurrencyAmount(getInvoiceDueAmount($invoice->id), $invoice->currency_id, true)); ?></strong>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </td>
                    </tr>
                </table>
                <?php if(!empty($invoice->note)): ?>
                <div class="mb-8">
                    <h6 class="d-fancy-title mb5"><?php echo e(__('messages.client.notes') . ':'); ?></h6>
                    <p class="font-color-gray"><?php echo nl2br($invoice->note ?? __('messages.common.not_available')); ?>

                    </p>
                </div>
                <?php endif; ?>
                <?php if(!empty($invoice->term)): ?>
                <div class="mb-8 w-75">
                    <h6 class="d-fancy-title mb5"><?php echo e(__('messages.invoice.terms') . ':'); ?></h6>
                    <p class="font-color-gray"><?php echo nl2br($invoice->term ?? __('messages.common.not_available')); ?> </p>
                </div>
                <?php endif; ?>
                <div class="w-25 text-end"
                    style="position:relative;
                                 top:10px;
                                 margin-left:auto;">
                    <h6 class="d-fancy-title mb5"><?php echo e(__('messages.setting.regards') . ':'); ?></h6>
                    <p class="fw-bold text-purple"
                        <?php echo e($styleCss); ?>="color:
                                    <?php echo e($invoice_template_color); ?>">
                        <b><?php echo e(html_entity_decode($setting['app_name'])); ?></b>
                    </p>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH /Users/fowusu/Herd/ims/resources/views/invoices/invoice_template_pdf/londonTemplate.blade.php ENDPATH**/ ?>